 ; Ŀ
 ;   Vertical Venetian Blind - adjust vertical text spacing.               
 ;   Copyright 1991, 1995, 2003, 2004, 2006 - 2009 by Rocket Software Ltd. 
 ;   Includes Vvbc, which also realigns text horizontally on the           
 ;   insertion point.                                                      
 ;   For those who would rather be hang gliding down Mount Everest.        
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Justv - returns a list of two letters describing the justification    
 ;   of the text or attdef entity whose data was its sole argument.        
 ; 
 (DEFUN JUSTV (entt / xjust yjust xjst yjst)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "TEXT")
      (setq yjust (cdr (assoc 73 entt)))
      (setq yjust (cdr (assoc 74 entt))))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T"))      ; top
        (T           (setq yjst "")))      ; default
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F"))      ; fit
        (T           (setq xjst "L")))     ; default
 (list yjst xjst))
 ; Ŀ
 ;   Justv end.                                                            
 ; 

 ; Ŀ
 ;   Shizl - check height and justification for an ss of text/attributes.  
 ;   Takes one argument, an ss.  Calls nothing.                            
 ;   Returns a list: (a real (the largest text height) or nil              
 ;                    T (= different height text found) or nil             
 ;                    a sublist of horizontal justifications               
 ;                    a sublist of vertical justifications)                
 ;   Calls Justv.                                                          
 ; 
 (DEFUN SHIZL (ss / num enam entt jlist vlist lhist hite difa hmax)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
 ; Ŀ
 ;   Get a list of x and y justifications for the entity.                  
 ; 
         (setq jlist (justv entt))
         (if (not (member (car jlist) vlist))
             (setq vlist (cons (car jlist) vlist)))
         (if (not (member (cadr jlist) lhist))
             (setq lhist (cons (cadr jlist) lhist)))
 ; Ŀ
 ;   Get its height.                                                       
 ; 
         (setq hite (cdr (assoc 40 entt)))
         (if (and hmax hite (/= hmax hite))
             (setq difa t))
         (if (or (null hmax) (> hite hmax))
             (setq hmax hite)))
 (list hmax difa vlist lhist))
 ; Ŀ
 ;   Shizl end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Warn - draw a temporary warning marker.                               
 ;   Arguments: Ctr, the insertion point.                                  
 ;   Returns nothing.  Calls nothing.                                      
 ; 
 (DEFUN WARN (ctr / prevhx prevhy scrsz vwhr vhh hwid xratio yratio minx
                                                  miny grlist num sub ten elv)
  (setq prevhx 20.79)
  (setq prevhy 13.25)
  (setq scrsz (getvar "screensize"))
  (setq vwhr (/ (car scrsz) (cadr scrsz)))
  (setq vhh (* (getvar "viewsize") 0.5))
  (setq hwid (* vhh vwhr))
  (setq xratio (/ hwid prevhx))
  (setq yratio (/ vhh prevhy))
  (setq minx (- (car ctr) hwid))
  (setq miny (- (cadr ctr) vhh))
  (setq grlist (list 
  '((16.58 12.94 0) (16.53 12.89 0) 1)
  '((16.53 12.89 0) (16.51 12.81 0) 1)
  '((16.51 12.81 0) (16.52 12.71 0) 1)
  '((16.52 12.71 0) (16.56 12.64 0) 1)
  '((16.56 12.64 0) (16.62 12.6 0) 1)
  '((16.62 12.6 0) (16.68 12.61 0) 1)
  '((16.68 12.61 0) (16.73 12.64 0) 1)
  '((16.73 12.64 0) (16.76 12.67 0) 1)
  '((16.76 12.67 0) (16.78 12.72 0) 1)
  '((16.78 12.72 0) (16.83 12.85 0) 1)
  '((16.83 12.85 0) (16.85 12.9 0) 1)
  '((16.85 12.9 0) (16.87 12.92 0) 1)
  '((16.87 12.92 0) (16.93 12.96 0) 1)
  '((16.93 12.96 0) (17.01 12.96 0) 1)
  '((17.01 12.96 0) (17.04 12.94 0) 1)
  '((17.04 12.94 0) (17.08 12.87 0) 1)
  '((17.08 12.87 0) (17.09 12.78 0) 1)
  '((17.09 12.78 0) (17.07 12.73 0) 1)
  '((17.07 12.73 0) (17.04 12.7 0) 1)
  '((17.04 12.7 0) (17.05 12.65 0) 1)
  '((16.58 12.94 0) (16.59 12.89 0) 1)
  '((16.59 12.89 0) (16.56 12.86 0) 1)
  '((16.56 12.86 0) (16.54 12.81 0) 1)
  '((16.54 12.81 0) (16.55 12.72 0) 1)
  '((16.55 12.72 0) (16.59 12.65 0) 1)
  '((16.59 12.65 0) (16.62 12.63 0) 1)
  '((16.62 12.63 0) (16.68 12.63 0) 1)
  '((16.68 12.63 0) (16.73 12.66 0) 1)
  '((16.73 12.66 0) (16.75 12.72 0) 1)
  '((16.75 12.72 0) (16.8 12.84 0) 1)
  '((16.8 12.84 0) (16.82 12.89 0) 1)
  '((16.82 12.89 0) (16.87 12.95 0) 1)
  '((16.87 12.95 0) (16.92 12.98 0) 1)
  '((16.92 12.98 0) (17.01 12.99 0) 1)
  '((17.01 12.99 0) (17.07 12.95 0) 1)
  '((17.07 12.95 0) (17.11 12.88 0) 1)
  '((17.11 12.88 0) (17.12 12.78 0) 1)
  '((17.12 12.78 0) (17.1 12.71 0) 1)
  '((17.1 12.71 0) (17.05 12.65 0) 1)
  '((16.71 12 0) (17.25 12.17 0) 1)
  '((16.7 12.03 0) (17.24 12.19 0) 1)
  '((17.24 12.19 0) (17.25 12.17 0) 1)
  '((16.72 11.85 0) (16.63 12.16 0) 1)
  '((16.63 12.16 0) (16.66 12.17 0) 1)
  '((16.72 11.85 0) (16.75 11.86 0) 1)
  '((16.75 11.86 0) (16.66 12.17 0) 1)
  '((17.57 11.41 0) (17.04 11.14 0) 1)
  '((17.04 11.14 0) (17.03 11.16 0) 1)
  '((17.03 11.16 0) (17.56 11.44 0) 1)
  '((17.56 11.44 0) (17.57 11.41 0) 1)
  '((17.57 11.41 0) (17.57 11.41 0) 1)
  '((16.88 11.44 0) (16.9 11.42 0) 1)
  '((16.9 11.42 0) (17.43 11.69 0) 1)
  '((17.43 11.69 0) (17.42 11.72 0) 1)
  '((17.42 11.72 0) (16.88 11.44 0) 1)
  '((16.88 11.44 0) (16.88 11.44 0) 1)
  '((17.28 11.29 0) (17.15 11.55 0) 1)
  '((17.31 11.3 0) (17.18 11.56 0) 1)
  '((17.38 10.87 0) (17.35 10.82 0) 1)
  '((17.35 10.82 0) (17.33 10.74 0) 1)
  '((17.33 10.74 0) (17.34 10.69 0) 1)
  '((17.34 10.69 0) (17.39 10.61 0) 1)
  '((17.39 10.61 0) (17.45 10.59 0) 1)
  '((17.45 10.59 0) (17.52 10.58 0) 1)
  '((17.52 10.58 0) (17.58 10.6 0) 1)
  '((17.58 10.6 0) (17.67 10.63 0) 1)
  '((17.67 10.63 0) (17.78 10.72 0) 1)
  '((17.78 10.72 0) (17.83 10.79 0) 1)
  '((17.83 10.79 0) (17.86 10.84 0) 1)
  '((17.86 10.84 0) (17.88 10.92 0) 1)
  '((17.88 10.92 0) (17.87 10.97 0) 1)
  '((17.87 10.97 0) (17.81 11.05 0) 1)
  '((17.81 11.05 0) (17.76 11.07 0) 1)
  '((17.76 11.07 0) (17.69 11.08 0) 1)
  '((17.69 11.08 0) (17.63 11.06 0) 1)
  '((17.63 11.06 0) (17.54 10.99 0) 1)
  '((17.54 10.99 0) (17.61 10.9 0) 1)
  '((17.38 10.87 0) (17.39 10.85 0) 1)
  '((17.39 10.85 0) (17.36 10.8 0) 1)
  '((17.36 10.8 0) (17.35 10.76 0) 1)
  '((17.35 10.76 0) (17.36 10.7 0) 1)
  '((17.36 10.7 0) (17.42 10.63 0) 1)
  '((17.42 10.63 0) (17.47 10.61 0) 1)
  '((17.47 10.61 0) (17.51 10.6 0) 1)
  '((17.51 10.6 0) (17.57 10.62 0) 1)
  '((17.57 10.62 0) (17.65 10.65 0) 1)
  '((17.65 10.65 0) (17.76 10.74 0) 1)
  '((17.76 10.74 0) (17.82 10.81 0) 1)
  '((17.82 10.81 0) (17.85 10.86 0) 1)
  '((17.85 10.86 0) (17.86 10.9 0) 1)
  '((17.86 10.9 0) (17.85 10.96 0) 1)
  '((17.85 10.96 0) (17.79 11.03 0) 1)
  '((17.79 11.03 0) (17.74 11.06 0) 1)
  '((17.74 11.06 0) (17.7 11.06 0) 1)
  '((17.7 11.06 0) (17.64 11.04 0) 1)
  '((17.64 11.04 0) (17.57 10.99 0) 1)
  '((17.57 10.99 0) (17.63 10.91 0) 1)
  '((17.63 10.91 0) (17.61 10.9 0) 1)
  '((17.9 10.06 0) (18.31 10.51 0) 1)
  '((18.31 10.51 0) (18.29 10.52 0) 1)
  '((17.9 10.06 0) (17.89 10.08 0) 1)
  '((17.89 10.08 0) (18.29 10.52 0) 1)
  '((18.63 9.53 0) (18.95 10.04 0) 1)
  '((18.63 9.56 0) (18.91 10.03 0) 1)
  '((18.63 9.53 0) (18.38 9.68 0) 1)
  '((18.63 9.56 0) (18.4 9.71 0) 1)
  '((18.4 9.71 0) (18.38 9.68 0) 1)
  '((18.76 9.78 0) (18.64 9.86 0) 1)
  '((18.64 9.86 0) (18.65 9.88 0) 1)
  '((18.65 9.88 0) (18.78 9.81 0) 1)
  '((18.91 10.03 0) (18.69 10.17 0) 1)
  '((18.69 10.17 0) (18.7 10.19 0) 1)
  '((18.7 10.19 0) (18.95 10.04 0) 1)
  '((19.58 9.75 0) (19.35 9.19 0) 1)
  '((19.35 9.19 0) (19.33 9.2 0) 1)
  '((19.33 9.2 0) (19.55 9.76 0) 1)
  '((19.55 9.76 0) (19.58 9.75 0) 1)
  '((19.58 9.75 0) (19.58 9.75 0) 1)
  '((19.04 9.32 0) (19.06 9.31 0) 1)
  '((19.06 9.31 0) (19.28 9.87 0) 1)
  '((19.28 9.87 0) (19.26 9.88 0) 1)
  '((19.26 9.88 0) (19.04 9.32 0) 1)
  '((19.04 9.32 0) (19.04 9.32 0) 1)
  '((19.44 9.47 0) (19.17 9.57 0) 1)
  '((19.45 9.49 0) (19.18 9.6 0) 1)
  '((20.71 8.98 0) (20.72 9.55 0) 1)
  '((20.69 8.98 0) (20.7 9.55 0) 1)
  '((20.7 9.55 0) (20.72 9.55 0) 1)
  '((20.86 8.95 0) (20.54 8.95 0) 1)
  '((20.54 8.95 0) (20.54 8.98 0) 1)
  '((20.86 8.95 0) (20.86 8.98 0) 1)
  '((20.86 8.98 0) (20.54 8.98 0) 1)
  '((21.64 9.03 0) (21.23 9.57 0) 1)
  '((21.23 9.57 0) (21.21 9.57 0) 1)
  '((21.64 9.03 0) (21.61 9.03 0) 1)
  '((21.61 9.03 0) (21.21 9.57 0) 1)
  '((21.3 8.98 0) (21.32 8.98 0) 1)
  '((21.32 8.98 0) (21.54 9.62 0) 1)
  '((21.3 8.98 0) (21.52 9.62 0) 1)
  '((21.52 9.62 0) (21.54 9.62 0) 1)
  '((22.35 9.24 0) (22.15 9.81 0) 1)
  '((22.32 9.26 0) (22.14 9.77 0) 1)
  '((22.35 9.24 0) (22.08 9.15 0) 1)
  '((22.32 9.26 0) (22.07 9.17 0) 1)
  '((22.07 9.17 0) (22.08 9.15 0) 1)
  '((22.24 9.5 0) (22.1 9.46 0) 1)
  '((22.1 9.46 0) (22.09 9.48 0) 1)
  '((22.09 9.48 0) (22.23 9.53 0) 1)
  '((22.14 9.77 0) (21.89 9.68 0) 1)
  '((21.89 9.68 0) (21.88 9.71 0) 1)
  '((21.88 9.71 0) (22.15 9.81 0) 1)
  '((22.91 9.54 0) (22.63 10.04 0) 1)
  '((22.89 9.53 0) (22.61 10.03 0) 1)
  '((22.61 10.03 0) (22.63 10.04 0) 1)
  '((23.05 9.59 0) (22.78 9.44 0) 1)
  '((22.78 9.44 0) (22.77 9.46 0) 1)
  '((23.05 9.59 0) (23.04 9.62 0) 1)
  '((23.04 9.62 0) (22.77 9.46 0) 1)
  '((24.08 10.53 0) (23.64 10.89 0) 1)
  '((24.06 10.51 0) (23.63 10.88 0) 1)
  '((23.63 10.88 0) (23.64 10.89 0) 1)
  '((24.19 10.62 0) (23.99 10.38 0) 1)
  '((23.99 10.38 0) (23.97 10.4 0) 1)
  '((24.19 10.62 0) (24.17 10.64 0) 1)
  '((24.17 10.64 0) (23.97 10.4 0) 1)
  '((24.61 11.28 0) (24.09 11.58 0) 1)
  '((24.53 11.3 0) (24.08 11.56 0) 1)
  '((24.08 11.56 0) (24.09 11.58 0) 1)
  '((24.53 11.3 0) (23.93 11.28 0) 1)
  '((24.61 11.28 0) (24.01 11.26 0) 1)
  '((24.01 11.26 0) (24.46 11.01 0) 1)
  '((24.46 11.01 0) (24.45 10.99 0) 1)
  '((24.45 10.99 0) (23.93 11.28 0) 1)
  '((24.9 11.98 0) (24.33 12.17 0) 1)
  '((24.86 11.96 0) (24.35 12.14 0) 1)
  '((24.9 11.98 0) (24.8 11.7 0) 1)
  '((24.86 11.96 0) (24.77 11.71 0) 1)
  '((24.77 11.71 0) (24.8 11.7 0) 1)
  '((24.62 12.05 0) (24.57 11.91 0) 1)
  '((24.57 11.91 0) (24.54 11.92 0) 1)
  '((24.54 11.92 0) (24.59 12.06 0) 1)
  '((24.35 12.14 0) (24.26 11.89 0) 1)
  '((24.26 11.89 0) (24.23 11.9 0) 1)
  '((24.23 11.9 0) (24.33 12.17 0) 1)
  '((25.06 12.74 0) (24.47 12.84 0) 1)
  '((25.03 12.72 0) (24.46 12.81 0) 1)
  '((24.46 12.81 0) (24.47 12.84 0) 1)
  '((25.06 12.74 0) (25.03 12.55 0) 1)
  '((25.03 12.55 0) (24.99 12.48 0) 1)
  '((24.99 12.48 0) (24.96 12.46 0) 1)
  '((24.96 12.46 0) (24.9 12.45 0) 1)
  '((24.9 12.45 0) (24.81 12.46 0) 1)
  '((24.81 12.46 0) (24.76 12.49 0) 1)
  '((24.76 12.49 0) (24.74 12.52 0) 1)
  '((24.74 12.52 0) (24.72 12.6 0) 1)
  '((24.72 12.6 0) (24.75 12.77 0) 1)
  '((25.03 12.72 0) (25 12.55 0) 1)
  '((25 12.55 0) (24.96 12.49 0) 1)
  '((24.96 12.49 0) (24.9 12.47 0) 1)
  '((24.9 12.47 0) (24.82 12.48 0) 1)
  '((24.82 12.48 0) (24.76 12.52 0) 1)
  '((24.76 12.52 0) (24.75 12.59 0) 1)
  '((24.75 12.59 0) (24.77 12.76 0) 1)
  '((24.73 12.65 0) (24.42 12.55 0) 1)
  '((24.42 12.55 0) (24.42 12.52 0) 1)
  '((24.42 12.52 0) (24.72 12.62 0) 1)
  '((25.08 13.5 0) (24.48 13.49 0) 1)
  '((25.05 13.48 0) (24.51 13.46 0) 1)
  '((25.08 13.5 0) (25.09 13.21 0) 1)
  '((25.05 13.48 0) (25.06 13.21 0) 1)
  '((25.06 13.21 0) (25.09 13.21 0) 1)
  '((24.8 13.47 0) (24.8 13.32 0) 1)
  '((24.8 13.32 0) (24.77 13.32 0) 1)
  '((24.77 13.32 0) (24.77 13.47 0) 1)
  '((24.51 13.46 0) (24.52 13.2 0) 1)
  '((24.52 13.2 0) (24.49 13.19 0) 1)
  '((24.49 13.19 0) (24.48 13.49 0) 1)
  '((24.97 14.26 0) (24.38 14.14 0) 1)
  '((24.95 14.23 0) (24.39 14.12 0) 1)
  '((24.39 14.12 0) (24.38 14.14 0) 1)
  '((24.97 14.26 0) (25.03 13.98 0) 1)
  '((24.95 14.23 0) (25 13.97 0) 1)
  '((25 13.97 0) (25.03 13.98 0) 1)
  '((24.69 14.18 0) (24.72 14.04 0) 1)
  '((24.72 14.04 0) (24.7 14.03 0) 1)
  '((24.7 14.03 0) (24.67 14.18 0) 1)
  '((24.72 15 0) (24.16 14.77 0) 1)
  '((24.7 14.96 0) (24.17 14.75 0) 1)
  '((24.17 14.75 0) (24.16 14.77 0) 1)
  '((24.72 15 0) (24.83 14.72 0) 1)
  '((24.7 14.96 0) (24.8 14.71 0) 1)
  '((24.8 14.71 0) (24.83 14.72 0) 1)
  '((24.47 14.87 0) (24.52 14.73 0) 1)
  '((24.52 14.73 0) (24.49 14.72 0) 1)
  '((24.49 14.72 0) (24.44 14.86 0) 1)
  '((24.42 15.56 0) (23.91 15.24 0) 1)
  '((23.91 15.24 0) (23.92 15.22 0) 1)
  '((24.42 15.56 0) (24.43 15.54 0) 1)
  '((24.43 15.54 0) (23.92 15.22 0) 1)
  '((23.84 16.28 0) (23.4 15.88 0) 1)
  '((23.84 16.25 0) (23.44 15.88 0) 1)
  '((23.84 16.28 0) (23.96 16.16 0) 1)
  '((23.96 16.16 0) (23.98 16.09 0) 1)
  '((23.98 16.09 0) (23.98 16.01 0) 1)
  '((23.98 16.01 0) (23.95 15.95 0) 1)
  '((23.95 15.95 0) (23.9 15.88 0) 1)
  '((23.9 15.88 0) (23.8 15.78 0) 1)
  '((23.8 15.78 0) (23.72 15.74 0) 1)
  '((23.72 15.74 0) (23.66 15.72 0) 1)
  '((23.66 15.72 0) (23.58 15.72 0) 1)
  '((23.58 15.72 0) (23.51 15.75 0) 1)
  '((23.51 15.75 0) (23.4 15.88 0) 1)
  '((23.84 16.25 0) (23.93 16.14 0) 1)
  '((23.93 16.14 0) (23.96 16.07 0) 1)
  '((23.96 16.07 0) (23.96 16.03 0) 1)
  '((23.96 16.03 0) (23.93 15.97 0) 1)
  '((23.93 15.97 0) (23.89 15.9 0) 1)
  '((23.89 15.9 0) (23.78 15.8 0) 1)
  '((23.78 15.8 0) (23.7 15.76 0) 1)
  '((23.7 15.76 0) (23.64 15.74 0) 1)
  '((23.64 15.74 0) (23.61 15.74 0) 1)
  '((23.61 15.74 0) (23.54 15.77 0) 1)
  '((23.54 15.77 0) (23.44 15.88 0) 1)
  '((22.68 17 0) (22.64 16.99 0) 1)
  '((22.64 16.99 0) (22.63 16.96 0) 1)
  '((22.63 16.96 0) (22.64 16.93 0) 1)
  '((22.64 16.93 0) (22.66 16.92 0) 1)
  '((22.66 16.92 0) (22.69 16.93 0) 1)
  '((22.69 16.93 0) (22.71 16.96 0) 1)
  '((22.71 16.96 0) (22.7 16.99 0) 1)
  '((22.7 16.99 0) (22.68 17 0) 1)
  '((22.68 17 0) (22.68 17 0) 1)
  '((22.66 16.98 0) (22.65 16.95 0) 1)
  '((22.65 16.95 0) (22.67 16.94 0) 1)
  '((22.67 16.94 0) (22.69 16.97 0) 1)
  '((22.69 16.97 0) (22.66 16.98 0) 1)
  '((22.66 16.98 0) (22.66 16.98 0) 1)
  '((22.53 16.72 0) (22.5 16.71 0) 1)
  '((22.5 16.71 0) (22.49 16.68 0) 1)
  '((22.49 16.68 0) (22.5 16.65 0) 1)
  '((22.5 16.65 0) (22.52 16.64 0) 1)
  '((22.52 16.64 0) (22.55 16.65 0) 1)
  '((22.55 16.65 0) (22.57 16.68 0) 1)
  '((22.57 16.68 0) (22.56 16.71 0) 1)
  '((22.56 16.71 0) (22.53 16.72 0) 1)
  '((22.53 16.72 0) (22.53 16.72 0) 1)
  '((22.52 16.7 0) (22.51 16.67 0) 1)
  '((22.51 16.67 0) (22.53 16.66 0) 1)
  '((22.53 16.66 0) (22.54 16.69 0) 1)
  '((22.54 16.69 0) (22.52 16.7 0) 1)
  '((22.52 16.7 0) (22.52 16.7 0) 1)
  '((22.15 17.18 0) (22.14 17.25 0) 1)
  '((22.14 17.25 0) (22.11 17.31 0) 1)
  '((22.11 17.31 0) (22.08 17.36 0) 1)
  '((22.08 17.36 0) (21.98 17.38 0) 1)
  '((21.98 17.38 0) (21.93 17.37 0) 1)
  '((21.93 17.37 0) (21.86 17.33 0) 1)
  '((21.86 17.33 0) (21.82 17.28 0) 1)
  '((21.82 17.28 0) (21.78 17.21 0) 1)
  '((21.78 17.21 0) (21.74 17.07 0) 1)
  '((21.74 17.07 0) (21.74 16.98 0) 1)
  '((21.74 16.98 0) (21.74 16.92 0) 1)
  '((21.74 16.92 0) (21.77 16.85 0) 1)
  '((21.77 16.85 0) (21.81 16.81 0) 1)
  '((21.81 16.81 0) (21.9 16.78 0) 1)
  '((21.9 16.78 0) (21.96 16.79 0) 1)
  '((21.96 16.79 0) (22.02 16.84 0) 1)
  '((22.02 16.84 0) (22.06 16.88 0) 1)
  '((22.06 16.88 0) (22.09 16.99 0) 1)
  '((22.09 16.99 0) (21.98 17.03 0) 1)
  '((22.15 17.18 0) (22.13 17.19 0) 1)
  '((22.13 17.19 0) (22.12 17.25 0) 1)
  '((22.12 17.25 0) (22.11 17.29 0) 1)
  '((22.11 17.29 0) (22.07 17.33 0) 1)
  '((22.07 17.33 0) (21.97 17.36 0) 1)
  '((21.97 17.36 0) (21.92 17.34 0) 1)
  '((21.92 17.34 0) (21.89 17.32 0) 1)
  '((21.89 17.32 0) (21.85 17.27 0) 1)
  '((21.85 17.27 0) (21.8 17.2 0) 1)
  '((21.8 17.2 0) (21.76 17.06 0) 1)
  '((21.76 17.06 0) (21.76 16.97 0) 1)
  '((21.76 16.97 0) (21.77 16.91 0) 1)
  '((21.77 16.91 0) (21.78 16.88 0) 1)
  '((21.78 16.88 0) (21.82 16.84 0) 1)
  '((21.82 16.84 0) (21.91 16.81 0) 1)
  '((21.91 16.81 0) (21.97 16.82 0) 1)
  '((21.97 16.82 0) (22 16.84 0) 1)
  '((22 16.84 0) (22.04 16.89 0) 1)
  '((22.04 16.89 0) (22.06 16.97 0) 1)
  '((22.06 16.97 0) (21.97 17 0) 1)
  '((21.97 17 0) (21.98 17.03 0) 1)
  '((21.09 17.54 0) (21.03 16.95 0) 1)
  '((21.11 17.46 0) (21.05 16.94 0) 1)
  '((21.05 16.94 0) (21.03 16.95 0) 1)
  '((21.11 17.46 0) (21.36 16.91 0) 1)
  '((21.09 17.54 0) (21.35 17 0) 1)
  '((21.35 17 0) (21.41 17.51 0) 1)
  '((21.41 17.51 0) (21.43 17.51 0) 1)
  '((21.43 17.51 0) (21.36 16.91 0) 1)
  '((20.48 17.54 0) (20.52 16.94 0) 1)
  '((20.52 16.94 0) (20.54 16.94 0) 1)
  '((20.48 17.54 0) (20.5 17.54 0) 1)
  '((20.5 17.54 0) (20.54 16.94 0) 1)
  '((19.57 17.38 0) (19.71 16.8 0) 1)
  '((19.61 17.3 0) (19.74 16.8 0) 1)
  '((19.74 16.8 0) (19.71 16.8 0) 1)
  '((19.61 17.3 0) (20.04 16.88 0) 1)
  '((19.57 17.38 0) (20 16.96 0) 1)
  '((20 16.96 0) (19.87 17.46 0) 1)
  '((19.87 17.46 0) (19.9 17.46 0) 1)
  '((19.9 17.46 0) (20.04 16.88 0) 1)
  '((18.86 17.1 0) (19.11 16.55 0) 1)
  '((18.89 17.08 0) (19.13 16.56 0) 1)
  '((19.13 16.56 0) (19.11 16.55 0) 1)
  '((18.86 17.1 0) (19.04 17.18 0) 1)
  '((19.04 17.18 0) (19.12 17.18 0) 1)
  '((19.12 17.18 0) (19.15 17.17 0) 1)
  '((19.15 17.17 0) (19.19 17.13 0) 1)
  '((19.19 17.13 0) (19.23 17.05 0) 1)
  '((19.23 17.05 0) (19.23 16.99 0) 1)
  '((19.23 16.99 0) (19.22 16.95 0) 1)
  '((19.22 16.95 0) (19.17 16.89 0) 1)
  '((19.17 16.89 0) (19.01 16.82 0) 1)
  '((18.89 17.08 0) (19.05 17.15 0) 1)
  '((19.05 17.15 0) (19.13 17.16 0) 1)
  '((19.13 17.16 0) (19.17 17.12 0) 1)
  '((19.17 17.12 0) (19.21 17.04 0) 1)
  '((19.21 17.04 0) (19.21 16.98 0) 1)
  '((19.21 16.98 0) (19.16 16.92 0) 1)
  '((19.16 16.92 0) (19 16.85 0) 1)
  '((19.12 16.87 0) (19.37 16.67 0) 1)
  '((19.37 16.67 0) (19.4 16.68 0) 1)
  '((19.4 16.68 0) (19.15 16.88 0) 1)
  '((18.33 16.78 0) (18.52 16.18 0) 1)
  '((18.38 16.71 0) (18.54 16.19 0) 1)
  '((18.54 16.19 0) (18.52 16.18 0) 1)
  '((18.38 16.71 0) (18.82 16.39 0) 1)
  '((18.82 16.39 0) (18.84 16.4 0) 1)
  '((18.84 16.4 0) (18.33 16.78 0) 1)
  '((18.48 16.36 0) (18.68 16.5 0) 1)
  '((18.47 16.32 0) (18.71 16.49 0) 1)
  '((18.08 15.78 0) (17.55 16.1 0) 1)
  '((17.55 16.1 0) (17.57 16.11 0) 1)
  '((17.57 16.11 0) (18.02 15.84 0) 1)
  '((18.02 15.84 0) (17.74 16.29 0) 1)
  '((18.08 15.78 0) (17.8 16.23 0) 1)
  '((17.8 16.23 0) (18.25 15.95 0) 1)
  '((17.74 16.29 0) (18.19 16.01 0) 1)
  '((17.93 16.48 0) (17.92 16.46 0) 1)
  '((17.92 16.46 0) (18.19 16.01 0) 1)
  '((17.93 16.48 0) (18.25 15.95 0) 1)
  '((24.23 13.25 0) (24.22 13.46 0) 4)
  '((24.22 13.46 0) (24.2 13.67 0) 4)
  '((24.2 13.67 0) (24.17 13.87 0) 4)
  '((24.17 13.87 0) (24.12 14.07 0) 4)
  '((24.12 14.07 0) (24.07 14.27 0) 4)
  '((24.07 14.27 0) (24 14.47 0) 4)
  '((24 14.47 0) (23.92 14.66 0) 4)
  '((23.92 14.66 0) (23.83 14.85 0) 4)
  '((23.83 14.85 0) (23.73 15.03 0) 4)
  '((23.73 15.03 0) (23.62 15.2 0) 4)
  '((23.62 15.2 0) (23.49 15.37 0) 4)
  '((23.49 15.37 0) (23.36 15.53 0) 4)
  '((23.36 15.53 0) (23.22 15.68 0) 4)
  '((23.22 15.68 0) (23.07 15.82 0) 4)
  '((23.07 15.82 0) (22.91 15.96 0) 4)
  '((22.91 15.96 0) (22.74 16.08 0) 4)
  '((22.74 16.08 0) (22.57 16.19 0) 4)
  '((22.57 16.19 0) (22.39 16.3 0) 4)
  '((22.39 16.3 0) (22.2 16.39 0) 4)
  '((22.2 16.39 0) (22.01 16.47 0) 4)
  '((22.01 16.47 0) (21.81 16.53 0) 4)
  '((21.81 16.53 0) (21.61 16.59 0) 4)
  '((21.61 16.59 0) (21.41 16.63 0) 4)
  '((21.41 16.63 0) (21.2 16.66 0) 4)
  '((21.2 16.66 0) (21 16.68 0) 4)
  '((21 16.68 0) (20.79 16.69 0) 4)
  '((20.79 16.69 0) (20.58 16.68 0) 4)
  '((20.58 16.68 0) (20.37 16.66 0) 4)
  '((20.37 16.66 0) (20.17 16.63 0) 4)
  '((20.17 16.63 0) (19.97 16.59 0) 4)
  '((19.97 16.59 0) (19.77 16.53 0) 4)
  '((19.77 16.53 0) (19.57 16.47 0) 4)
  '((19.57 16.47 0) (19.38 16.39 0) 4)
  '((19.38 16.39 0) (19.19 16.3 0) 4)
  '((19.19 16.3 0) (19.01 16.19 0) 4)
  '((19.01 16.19 0) (18.84 16.08 0) 4)
  '((18.84 16.08 0) (18.67 15.96 0) 4)
  '((18.67 15.96 0) (18.51 15.82 0) 4)
  '((18.51 15.82 0) (18.36 15.68 0) 4)
  '((18.36 15.68 0) (18.22 15.53 0) 4)
  '((18.22 15.53 0) (18.08 15.37 0) 4)
  '((18.08 15.37 0) (17.96 15.2 0) 4)
  '((17.96 15.2 0) (17.85 15.03 0) 4)
  '((17.85 15.03 0) (17.75 14.85 0) 4)
  '((17.75 14.85 0) (17.66 14.66 0) 4)
  '((17.66 14.66 0) (17.58 14.47 0) 4)
  '((17.58 14.47 0) (17.51 14.27 0) 4)
  '((17.51 14.27 0) (17.45 14.07 0) 4)
  '((17.45 14.07 0) (17.41 13.87 0) 4)
  '((17.41 13.87 0) (17.38 13.67 0) 4)
  '((17.38 13.67 0) (17.36 13.46 0) 4)
  '((17.36 13.46 0) (17.35 13.25 0) 4)
  '((17.35 13.25 0) (17.36 13.04 0) 4)
  '((17.36 13.04 0) (17.38 12.84 0) 4)
  '((17.38 12.84 0) (17.41 12.63 0) 4)
  '((17.41 12.63 0) (17.45 12.43 0) 4)
  '((17.45 12.43 0) (17.51 12.23 0) 4)
  '((17.51 12.23 0) (17.58 12.03 0) 4)
  '((17.58 12.03 0) (17.66 11.84 0) 4)
  '((17.66 11.84 0) (17.75 11.65 0) 4)
  '((17.75 11.65 0) (17.85 11.47 0) 4)
  '((17.85 11.47 0) (17.96 11.3 0) 4)
  '((17.96 11.3 0) (18.08 11.13 0) 4)
  '((18.08 11.13 0) (18.22 10.97 0) 4)
  '((18.22 10.97 0) (18.36 10.82 0) 4)
  '((18.36 10.82 0) (18.51 10.68 0) 4)
  '((18.51 10.68 0) (18.67 10.54 0) 4)
  '((18.67 10.54 0) (18.84 10.42 0) 4)
  '((18.84 10.42 0) (19.01 10.31 0) 4)
  '((19.01 10.31 0) (19.19 10.21 0) 4)
  '((19.19 10.21 0) (19.38 10.12 0) 4)
  '((19.38 10.12 0) (19.57 10.04 0) 4)
  '((19.57 10.04 0) (19.77 9.97 0) 4)
  '((19.77 9.97 0) (19.97 9.91 0) 4)
  '((19.97 9.91 0) (20.17 9.87 0) 4)
  '((20.17 9.87 0) (20.37 9.84 0) 4)
  '((20.37 9.84 0) (20.58 9.82 0) 4)
  '((20.58 9.82 0) (20.79 9.81 0) 4)
  '((20.79 9.81 0) (21 9.82 0) 4)
  '((21 9.82 0) (21.2 9.84 0) 4)
  '((21.2 9.84 0) (21.41 9.87 0) 4)
  '((21.41 9.87 0) (21.61 9.91 0) 4)
  '((21.61 9.91 0) (21.81 9.97 0) 4)
  '((21.81 9.97 0) (22.01 10.04 0) 4)
  '((22.01 10.04 0) (22.2 10.12 0) 4)
  '((22.2 10.12 0) (22.39 10.21 0) 4)
  '((22.39 10.21 0) (22.57 10.31 0) 4)
  '((22.57 10.31 0) (22.74 10.42 0) 4)
  '((22.74 10.42 0) (22.91 10.54 0) 4)
  '((22.91 10.54 0) (23.07 10.68 0) 4)
  '((23.07 10.68 0) (23.22 10.82 0) 4)
  '((23.22 10.82 0) (23.36 10.97 0) 4)
  '((23.36 10.97 0) (23.49 11.13 0) 4)
  '((23.49 11.13 0) (23.62 11.3 0) 4)
  '((23.62 11.3 0) (23.73 11.47 0) 4)
  '((23.73 11.47 0) (23.83 11.65 0) 4)
  '((23.83 11.65 0) (23.92 11.84 0) 4)
  '((23.92 11.84 0) (24 12.03 0) 4)
  '((24 12.03 0) (24.07 12.23 0) 4)
  '((24.07 12.23 0) (24.12 12.43 0) 4)
  '((24.12 12.43 0) (24.17 12.63 0) 4)
  '((24.17 12.63 0) (24.2 12.84 0) 4)
  '((24.2 12.84 0) (24.22 13.04 0) 4)
  '((24.22 13.04 0) (24.23 13.25 0) 4)
  '((24.23 13.25 0) (24.23 13.25 0) 4)
  '((25.35 13.25 0) (25.34 13.5 0) 4)
  '((25.34 13.5 0) (25.32 13.74 0) 4)
  '((25.32 13.74 0) (25.29 13.99 0) 4)
  '((25.29 13.99 0) (25.24 14.23 0) 4)
  '((25.24 14.23 0) (25.18 14.47 0) 4)
  '((25.18 14.47 0) (25.11 14.71 0) 4)
  '((25.11 14.71 0) (25.03 14.94 0) 4)
  '((25.03 14.94 0) (24.93 15.17 0) 4)
  '((24.93 15.17 0) (24.82 15.39 0) 4)
  '((24.82 15.39 0) (24.7 15.6 0) 4)
  '((24.7 15.6 0) (24.56 15.81 0) 4)
  '((24.56 15.81 0) (24.42 16.01 0) 4)
  '((24.42 16.01 0) (24.27 16.21 0) 4)
  '((24.27 16.21 0) (24.1 16.39 0) 4)
  '((24.1 16.39 0) (23.92 16.56 0) 4)
  '((23.92 16.56 0) (23.74 16.73 0) 4)
  '((23.74 16.73 0) (23.55 16.88 0) 4)
  '((23.55 16.88 0) (23.35 17.03 0) 4)
  '((23.35 17.03 0) (23.14 17.16 0) 4)
  '((23.14 17.16 0) (22.92 17.28 0) 4)
  '((22.92 17.28 0) (22.7 17.39 0) 4)
  '((22.7 17.39 0) (22.48 17.49 0) 4)
  '((22.48 17.49 0) (22.25 17.58 0) 4)
  '((22.25 17.58 0) (22.01 17.65 0) 4)
  '((22.01 17.65 0) (21.77 17.71 0) 4)
  '((21.77 17.71 0) (21.53 17.75 0) 4)
  '((21.53 17.75 0) (21.28 17.79 0) 4)
  '((21.28 17.79 0) (21.04 17.81 0) 4)
  '((21.04 17.81 0) (20.79 17.81 0) 4)
  '((20.79 17.81 0) (20.54 17.81 0) 4)
  '((20.54 17.81 0) (20.3 17.79 0) 4)
  '((20.3 17.79 0) (20.05 17.75 0) 4)
  '((20.05 17.75 0) (19.81 17.71 0) 4)
  '((19.81 17.71 0) (19.57 17.65 0) 4)
  '((19.57 17.65 0) (19.33 17.58 0) 4)
  '((19.33 17.58 0) (19.1 17.49 0) 4)
  '((19.1 17.49 0) (18.87 17.39 0) 4)
  '((18.87 17.39 0) (18.65 17.28 0) 4)
  '((18.65 17.28 0) (18.44 17.16 0) 4)
  '((18.44 17.16 0) (18.23 17.03 0) 4)
  '((18.23 17.03 0) (18.03 16.88 0) 4)
  '((18.03 16.88 0) (17.84 16.73 0) 4)
  '((17.84 16.73 0) (17.65 16.56 0) 4)
  '((17.65 16.56 0) (17.48 16.39 0) 4)
  '((17.48 16.39 0) (17.31 16.21 0) 4)
  '((17.31 16.21 0) (17.16 16.01 0) 4)
  '((17.16 16.01 0) (17.01 15.81 0) 4)
  '((17.01 15.81 0) (16.88 15.6 0) 4)
  '((16.88 15.6 0) (16.76 15.39 0) 4)
  '((16.76 15.39 0) (16.65 15.17 0) 4)
  '((16.65 15.17 0) (16.55 14.94 0) 4)
  '((16.55 14.94 0) (16.47 14.71 0) 4)
  '((16.47 14.71 0) (16.39 14.47 0) 4)
  '((16.39 14.47 0) (16.33 14.23 0) 4)
  '((16.33 14.23 0) (16.29 13.99 0) 4)
  '((16.29 13.99 0) (16.25 13.74 0) 4)
  '((16.25 13.74 0) (16.23 13.5 0) 4)
  '((16.23 13.5 0) (16.23 13.25 0) 4)
  '((16.23 13.25 0) (16.23 13 0) 4)
  '((16.23 13 0) (16.25 12.76 0) 4)
  '((16.25 12.76 0) (16.29 12.51 0) 4)
  '((16.29 12.51 0) (16.33 12.27 0) 4)
  '((16.33 12.27 0) (16.39 12.03 0) 4)
  '((16.39 12.03 0) (16.47 11.79 0) 4)
  '((16.47 11.79 0) (16.55 11.56 0) 4)
  '((16.55 11.56 0) (16.65 11.33 0) 4)
  '((16.65 11.33 0) (16.76 11.11 0) 4)
  '((16.76 11.11 0) (16.88 10.9 0) 4)
  '((16.88 10.9 0) (17.01 10.69 0) 4)
  '((17.01 10.69 0) (17.16 10.49 0) 4)
  '((17.16 10.49 0) (17.31 10.3 0) 4)
  '((17.31 10.3 0) (17.48 10.11 0) 4)
  '((17.48 10.11 0) (17.65 9.94 0) 4)
  '((17.65 9.94 0) (17.84 9.77 0) 4)
  '((17.84 9.77 0) (18.03 9.62 0) 4)
  '((18.03 9.62 0) (18.23 9.47 0) 4)
  '((18.23 9.47 0) (18.44 9.34 0) 4)
  '((18.44 9.34 0) (18.65 9.22 0) 4)
  '((18.65 9.22 0) (18.87 9.11 0) 4)
  '((18.87 9.11 0) (19.1 9.01 0) 4)
  '((19.1 9.01 0) (19.33 8.93 0) 4)
  '((19.33 8.93 0) (19.57 8.85 0) 4)
  '((19.57 8.85 0) (19.81 8.79 0) 4)
  '((19.81 8.79 0) (20.05 8.75 0) 4)
  '((20.05 8.75 0) (20.3 8.71 0) 4)
  '((20.3 8.71 0) (20.54 8.69 0) 4)
  '((20.54 8.69 0) (20.79 8.69 0) 4)
  '((20.79 8.69 0) (21.04 8.69 0) 4)
  '((21.04 8.69 0) (21.28 8.71 0) 4)
  '((21.28 8.71 0) (21.53 8.75 0) 4)
  '((21.53 8.75 0) (21.77 8.79 0) 4)
  '((21.77 8.79 0) (22.01 8.85 0) 4)
  '((22.01 8.85 0) (22.25 8.93 0) 4)
  '((22.25 8.93 0) (22.48 9.01 0) 4)
  '((22.48 9.01 0) (22.7 9.11 0) 4)
  '((22.7 9.11 0) (22.92 9.22 0) 4)
  '((22.92 9.22 0) (23.14 9.34 0) 4)
  '((23.14 9.34 0) (23.35 9.47 0) 4)
  '((23.35 9.47 0) (23.55 9.62 0) 4)
  '((23.55 9.62 0) (23.74 9.77 0) 4)
  '((23.74 9.77 0) (23.92 9.94 0) 4)
  '((23.92 9.94 0) (24.1 10.11 0) 4)
  '((24.1 10.11 0) (24.27 10.3 0) 4)
  '((24.27 10.3 0) (24.42 10.49 0) 4)
  '((24.42 10.49 0) (24.56 10.69 0) 4)
  '((24.56 10.69 0) (24.7 10.9 0) 4)
  '((24.7 10.9 0) (24.82 11.11 0) 4)
  '((24.82 11.11 0) (24.93 11.33 0) 4)
  '((24.93 11.33 0) (25.03 11.56 0) 4)
  '((25.03 11.56 0) (25.11 11.79 0) 4)
  '((25.11 11.79 0) (25.18 12.03 0) 4)
  '((25.18 12.03 0) (25.24 12.27 0) 4)
  '((25.24 12.27 0) (25.29 12.51 0) 4)
  '((25.29 12.51 0) (25.32 12.76 0) 4)
  '((25.32 12.76 0) (25.34 13 0) 4)
  '((25.34 13 0) (25.35 13.25 0) 4)
  '((25.35 13.25 0) (25.35 13.25 0) 4)
  '((21.29 11 0) (21.28 11.08 0) 4)
  '((21.28 11.08 0) (21.26 11.15 0) 4)
  '((21.26 11.15 0) (21.23 11.23 0) 4)
  '((21.23 11.23 0) (21.19 11.29 0) 4)
  '((21.19 11.29 0) (21.14 11.35 0) 4)
  '((21.14 11.35 0) (21.08 11.4 0) 4)
  '((21.08 11.4 0) (21.01 11.45 0) 4)
  '((21.01 11.45 0) (20.94 11.48 0) 4)
  '((20.94 11.48 0) (20.87 11.49 0) 4)
  '((20.87 11.49 0) (20.79 11.5 0) 4)
  '((20.79 11.5 0) (20.71 11.49 0) 4)
  '((20.71 11.49 0) (20.63 11.48 0) 4)
  '((20.63 11.48 0) (20.56 11.45 0) 4)
  '((20.56 11.45 0) (20.49 11.4 0) 4)
  '((20.49 11.4 0) (20.43 11.35 0) 4)
  '((20.43 11.35 0) (20.38 11.29 0) 4)
  '((20.38 11.29 0) (20.34 11.23 0) 4)
  '((20.34 11.23 0) (20.31 11.15 0) 4)
  '((20.31 11.15 0) (20.29 11.08 0) 4)
  '((20.29 11.08 0) (20.29 11 0) 4)
  '((20.29 11 0) (20.29 10.92 0) 4)
  '((20.29 10.92 0) (20.31 10.85 0) 4)
  '((20.31 10.85 0) (20.34 10.77 0) 4)
  '((20.34 10.77 0) (20.38 10.71 0) 4)
  '((20.38 10.71 0) (20.43 10.65 0) 4)
  '((20.43 10.65 0) (20.49 10.59 0) 4)
  '((20.49 10.59 0) (20.56 10.55 0) 4)
  '((20.56 10.55 0) (20.63 10.52 0) 4)
  '((20.63 10.52 0) (20.71 10.51 0) 4)
  '((20.71 10.51 0) (20.79 10.5 0) 4)
  '((20.79 10.5 0) (20.87 10.51 0) 4)
  '((20.87 10.51 0) (20.94 10.52 0) 4)
  '((20.94 10.52 0) (21.01 10.55 0) 4)
  '((21.01 10.55 0) (21.08 10.59 0) 4)
  '((21.08 10.59 0) (21.14 10.65 0) 4)
  '((21.14 10.65 0) (21.19 10.71 0) 4)
  '((21.19 10.71 0) (21.23 10.77 0) 4)
  '((21.23 10.77 0) (21.26 10.85 0) 4)
  '((21.26 10.85 0) (21.28 10.92 0) 4)
  '((21.28 10.92 0) (21.29 11 0) 4)
  '((21.29 11 0) (21.29 11 0) 4)
  '((20.29 12.35 0) (20.16 15.35 0) 4)
  '((21.41 15.35 0) (21.41 15.44 0) 4)
  '((21.41 15.44 0) (21.4 15.52 0) 4)
  '((21.4 15.52 0) (21.37 15.61 0) 4)
  '((21.37 15.61 0) (21.33 15.69 0) 4)
  '((21.33 15.69 0) (21.28 15.76 0) 4)
  '((21.28 15.76 0) (21.22 15.83 0) 4)
  '((21.22 15.83 0) (21.16 15.88 0) 4)
  '((21.16 15.88 0) (21.08 15.93 0) 4)
  '((21.08 15.93 0) (21 15.96 0) 4)
  '((21 15.96 0) (20.92 15.99 0) 4)
  '((20.92 15.99 0) (20.83 16 0) 4)
  '((20.83 16 0) (20.74 16 0) 4)
  '((20.74 16 0) (20.66 15.99 0) 4)
  '((20.66 15.99 0) (20.57 15.96 0) 4)
  '((20.57 15.96 0) (20.49 15.93 0) 4)
  '((20.49 15.93 0) (20.42 15.88 0) 4)
  '((20.42 15.88 0) (20.35 15.83 0) 4)
  '((20.35 15.83 0) (20.29 15.76 0) 4)
  '((20.29 15.76 0) (20.25 15.69 0) 4)
  '((20.25 15.69 0) (20.21 15.61 0) 4)
  '((20.21 15.61 0) (20.18 15.52 0) 4)
  '((20.18 15.52 0) (20.17 15.44 0) 4)
  '((20.17 15.44 0) (20.16 15.35 0) 4)
  '((21.41 15.35 0) (21.29 12.35 0) 4)
  '((20.29 12.35 0) (20.3 12.28 0) 4)
  '((20.3 12.28 0) (20.32 12.2 0) 4)
  '((20.32 12.2 0) (20.36 12.13 0) 4)
  '((20.36 12.13 0) (20.4 12.06 0) 4)
  '((20.4 12.06 0) (20.46 12 0) 4)
  '((20.46 12 0) (20.52 11.95 0) 4)
  '((20.52 11.95 0) (20.59 11.92 0) 4)
  '((20.59 11.92 0) (20.67 11.89 0) 4)
  '((20.67 11.89 0) (20.75 11.88 0) 4)
  '((20.75 11.88 0) (20.83 11.88 0) 4)
  '((20.83 11.88 0) (20.91 11.89 0) 4)
  '((20.91 11.89 0) (20.98 11.92 0) 4)
  '((20.98 11.92 0) (21.06 11.95 0) 4)
  '((21.06 11.95 0) (21.12 12 0) 4)
  '((21.12 12 0) (21.18 12.06 0) 4)
  '((21.18 12.06 0) (21.22 12.13 0) 4)
  '((21.22 12.13 0) (21.26 12.2 0) 4)
  '((21.26 12.2 0) (21.28 12.28 0) 4)
  '((21.28 12.28 0) (21.29 12.35 0) 4)
  '((17.24 14.52 0) (17.24 14.57 0) 1)
  '((17.24 14.57 0) (17.22 14.62 0) 1)
  '((17.22 14.62 0) (17.19 14.67 0) 1)
  '((17.19 14.67 0) (17.15 14.71 0) 1)
  '((17.15 14.71 0) (17.1 14.74 0) 1)
  '((17.1 14.74 0) (17.05 14.76 0) 1)
  '((17.05 14.76 0) (16.99 14.77 0) 1)
  '((16.99 14.77 0) (16.94 14.76 0) 1)
  '((16.94 14.76 0) (16.89 14.74 0) 1)
  '((16.89 14.74 0) (16.84 14.71 0) 1)
  '((16.84 14.71 0) (16.8 14.67 0) 1)
  '((16.8 14.67 0) (16.77 14.62 0) 1)
  '((16.77 14.62 0) (16.75 14.57 0) 1)
  '((16.75 14.57 0) (16.74 14.52 0) 1)
  '((16.74 14.52 0) (16.75 14.46 0) 1)
  '((16.75 14.46 0) (16.77 14.41 0) 1)
  '((16.77 14.41 0) (16.8 14.36 0) 1)
  '((16.8 14.36 0) (16.84 14.32 0) 1)
  '((16.84 14.32 0) (16.89 14.29 0) 1)
  '((16.89 14.29 0) (16.94 14.27 0) 1)
  '((16.94 14.27 0) (16.99 14.27 0) 1)
  '((16.99 14.27 0) (17.05 14.27 0) 1)
  '((17.05 14.27 0) (17.1 14.29 0) 1)
  '((17.1 14.29 0) (17.15 14.32 0) 1)
  '((17.15 14.32 0) (17.19 14.36 0) 1)
  '((17.19 14.36 0) (17.22 14.41 0) 1)
  '((17.22 14.41 0) (17.24 14.46 0) 1)
  '((17.24 14.46 0) (17.24 14.52 0) 1)
  '((17.24 14.52 0) (17.24 14.52 0) 1)
  '((25.48 13.25 0) (25.47 13.5 0) 4)
  '((25.47 13.5 0) (25.45 13.74 0) 4)
  '((25.45 13.74 0) (25.42 13.98 0) 4)
  '((25.42 13.98 0) (25.37 14.23 0) 4)
  '((25.37 14.23 0) (25.31 14.46 0) 4)
  '((25.31 14.46 0) (25.25 14.7 0) 4)
  '((25.25 14.7 0) (25.16 14.93 0) 4)
  '((25.16 14.93 0) (25.07 15.16 0) 4)
  '((25.07 15.16 0) (24.96 15.38 0) 4)
  '((24.96 15.38 0) (24.85 15.6 0) 4)
  '((24.85 15.6 0) (24.72 15.8 0) 4)
  '((24.72 15.8 0) (24.58 16.01 0) 4)
  '((24.58 16.01 0) (24.43 16.2 0) 4)
  '((24.43 16.2 0) (24.27 16.39 0) 4)
  '((24.27 16.39 0) (24.1 16.57 0) 4)
  '((24.1 16.57 0) (23.92 16.74 0) 4)
  '((23.92 16.74 0) (23.74 16.9 0) 4)
  '((23.74 16.9 0) (23.54 17.04 0) 4)
  '((23.54 17.04 0) (23.34 17.18 0) 4)
  '((23.34 17.18 0) (23.13 17.31 0) 4)
  '((23.13 17.31 0) (22.92 17.43 0) 4)
  '((22.92 17.43 0) (22.69 17.53 0) 4)
  '((22.69 17.53 0) (22.47 17.63 0) 4)
  '((22.47 17.63 0) (22.24 17.71 0) 4)
  '((22.24 17.71 0) (22 17.78 0) 4)
  '((22 17.78 0) (21.76 17.84 0) 4)
  '((21.76 17.84 0) (21.52 17.88 0) 4)
  '((21.52 17.88 0) (21.28 17.91 0) 4)
  '((21.28 17.91 0) (21.03 17.93 0) 4)
  '((21.03 17.93 0) (20.79 17.94 0) 4)
  '((20.79 17.94 0) (20.54 17.93 0) 4)
  '((20.54 17.93 0) (20.3 17.91 0) 4)
  '((20.3 17.91 0) (20.06 17.88 0) 4)
  '((20.06 17.88 0) (19.81 17.84 0) 4)
  '((19.81 17.84 0) (19.58 17.78 0) 4)
  '((19.58 17.78 0) (19.34 17.71 0) 4)
  '((19.34 17.71 0) (19.11 17.63 0) 4)
  '((19.11 17.63 0) (18.88 17.53 0) 4)
  '((18.88 17.53 0) (18.66 17.43 0) 4)
  '((18.66 17.43 0) (18.45 17.31 0) 4)
  '((18.45 17.31 0) (18.24 17.18 0) 4)
  '((18.24 17.18 0) (18.03 17.04 0) 4)
  '((18.03 17.04 0) (17.84 16.9 0) 4)
  '((17.84 16.9 0) (17.65 16.74 0) 4)
  '((17.65 16.74 0) (17.48 16.57 0) 4)
  '((17.48 16.57 0) (17.31 16.39 0) 4)
  '((17.31 16.39 0) (17.15 16.2 0) 4)
  '((17.15 16.2 0) (17 16.01 0) 4)
  '((17 16.01 0) (16.86 15.8 0) 4)
  '((16.86 15.8 0) (16.73 15.6 0) 4)
  '((16.73 15.6 0) (16.61 15.38 0) 4)
  '((16.61 15.38 0) (16.51 15.16 0) 4)
  '((16.51 15.16 0) (16.41 14.93 0) 4)
  '((16.41 14.93 0) (16.33 14.7 0) 4)
  '((16.33 14.7 0) (16.26 14.46 0) 4)
  '((16.26 14.46 0) (16.21 14.23 0) 4)
  '((16.21 14.23 0) (16.16 13.98 0) 4)
  '((16.16 13.98 0) (16.13 13.74 0) 4)
  '((16.13 13.74 0) (16.11 13.5 0) 4)
  '((16.11 13.5 0) (16.1 13.25 0) 4)
  '((16.1 13.25 0) (16.11 13 0) 4)
  '((16.11 13 0) (16.13 12.76 0) 4)
  '((16.13 12.76 0) (16.16 12.52 0) 4)
  '((16.16 12.52 0) (16.21 12.28 0) 4)
  '((16.21 12.28 0) (16.26 12.04 0) 4)
  '((16.26 12.04 0) (16.33 11.8 0) 4)
  '((16.33 11.8 0) (16.41 11.57 0) 4)
  '((16.41 11.57 0) (16.51 11.34 0) 4)
  '((16.51 11.34 0) (16.61 11.12 0) 4)
  '((16.61 11.12 0) (16.73 10.91 0) 4)
  '((16.73 10.91 0) (16.86 10.7 0) 4)
  '((16.86 10.7 0) (17 10.49 0) 4)
  '((17 10.49 0) (17.15 10.3 0) 4)
  '((17.15 10.3 0) (17.31 10.11 0) 4)
  '((17.31 10.11 0) (17.48 9.94 0) 4)
  '((17.48 9.94 0) (17.65 9.77 0) 4)
  '((17.65 9.77 0) (17.84 9.61 0) 4)
  '((17.84 9.61 0) (18.03 9.46 0) 4)
  '((18.03 9.46 0) (18.24 9.32 0) 4)
  '((18.24 9.32 0) (18.45 9.19 0) 4)
  '((18.45 9.19 0) (18.66 9.07 0) 4)
  '((18.66 9.07 0) (18.88 8.97 0) 4)
  '((18.88 8.97 0) (19.11 8.87 0) 4)
  '((19.11 8.87 0) (19.34 8.79 0) 4)
  '((19.34 8.79 0) (19.58 8.72 0) 4)
  '((19.58 8.72 0) (19.81 8.66 0) 4)
  '((19.81 8.66 0) (20.06 8.62 0) 4)
  '((20.06 8.62 0) (20.3 8.59 0) 4)
  '((20.3 8.59 0) (20.54 8.57 0) 4)
  '((20.54 8.57 0) (20.79 8.56 0) 4)
  '((20.79 8.56 0) (21.03 8.57 0) 4)
  '((21.03 8.57 0) (21.28 8.59 0) 4)
  '((21.28 8.59 0) (21.52 8.62 0) 4)
  '((21.52 8.62 0) (21.76 8.66 0) 4)
  '((21.76 8.66 0) (22 8.72 0) 4)
  '((22 8.72 0) (22.24 8.79 0) 4)
  '((22.24 8.79 0) (22.47 8.87 0) 4)
  '((22.47 8.87 0) (22.69 8.97 0) 4)
  '((22.69 8.97 0) (22.92 9.07 0) 4)
  '((22.92 9.07 0) (23.13 9.19 0) 4)
  '((23.13 9.19 0) (23.34 9.32 0) 4)
  '((23.34 9.32 0) (23.54 9.46 0) 4)
  '((23.54 9.46 0) (23.74 9.61 0) 4)
  '((23.74 9.61 0) (23.92 9.77 0) 4)
  '((23.92 9.77 0) (24.1 9.94 0) 4)
  '((24.1 9.94 0) (24.27 10.11 0) 4)
  '((24.27 10.11 0) (24.43 10.3 0) 4)
  '((24.43 10.3 0) (24.58 10.49 0) 4)
  '((24.58 10.49 0) (24.72 10.7 0) 4)
  '((24.72 10.7 0) (24.85 10.91 0) 4)
  '((24.85 10.91 0) (24.96 11.12 0) 4)
  '((24.96 11.12 0) (25.07 11.34 0) 4)
  '((25.07 11.34 0) (25.16 11.57 0) 4)
  '((25.16 11.57 0) (25.25 11.8 0) 4)
  '((25.25 11.8 0) (25.31 12.04 0) 4)
  '((25.31 12.04 0) (25.37 12.28 0) 4)
  '((25.37 12.28 0) (25.42 12.52 0) 4)
  '((25.42 12.52 0) (25.45 12.76 0) 4)
  '((25.45 12.76 0) (25.47 13 0) 4)
  '((25.47 13 0) (25.48 13.25 0) 4)
  '((25.48 13.25 0) (25.48 13.25 0) 4)
  '((24.1 13.25 0) (24.09 13.46 0) 4)
  '((24.09 13.46 0) (24.07 13.67 0) 4)
  '((24.07 13.67 0) (24.04 13.87 0) 4)
  '((24.04 13.87 0) (24 14.07 0) 4)
  '((24 14.07 0) (23.94 14.27 0) 4)
  '((23.94 14.27 0) (23.87 14.47 0) 4)
  '((23.87 14.47 0) (23.78 14.66 0) 4)
  '((23.78 14.66 0) (23.69 14.85 0) 4)
  '((23.69 14.85 0) (23.58 15.03 0) 4)
  '((23.58 15.03 0) (23.47 15.2 0) 4)
  '((23.47 15.2 0) (23.34 15.36 0) 4)
  '((23.34 15.36 0) (23.2 15.52 0) 4)
  '((23.2 15.52 0) (23.06 15.67 0) 4)
  '((23.06 15.67 0) (22.9 15.8 0) 4)
  '((22.9 15.8 0) (22.74 15.93 0) 4)
  '((22.74 15.93 0) (22.56 16.05 0) 4)
  '((22.56 16.05 0) (22.38 16.15 0) 4)
  '((22.38 16.15 0) (22.2 16.25 0) 4)
  '((22.2 16.25 0) (22.01 16.33 0) 4)
  '((22.01 16.33 0) (21.81 16.4 0) 4)
  '((21.81 16.4 0) (21.61 16.46 0) 4)
  '((21.61 16.46 0) (21.41 16.51 0) 4)
  '((21.41 16.51 0) (21.2 16.54 0) 4)
  '((21.2 16.54 0) (21 16.56 0) 4)
  '((21 16.56 0) (20.79 16.56 0) 4)
  '((20.79 16.56 0) (20.58 16.56 0) 4)
  '((20.58 16.56 0) (20.37 16.54 0) 4)
  '((20.37 16.54 0) (20.17 16.51 0) 4)
  '((20.17 16.51 0) (19.97 16.46 0) 4)
  '((19.97 16.46 0) (19.77 16.4 0) 4)
  '((19.77 16.4 0) (19.57 16.33 0) 4)
  '((19.57 16.33 0) (19.38 16.25 0) 4)
  '((19.38 16.25 0) (19.19 16.15 0) 4)
  '((19.19 16.15 0) (19.01 16.05 0) 4)
  '((19.01 16.05 0) (18.84 15.93 0) 4)
  '((18.84 15.93 0) (18.68 15.8 0) 4)
  '((18.68 15.8 0) (18.52 15.67 0) 4)
  '((18.52 15.67 0) (18.37 15.52 0) 4)
  '((18.37 15.52 0) (18.24 15.36 0) 4)
  '((18.24 15.36 0) (18.11 15.2 0) 4)
  '((18.11 15.2 0) (17.99 15.03 0) 4)
  '((17.99 15.03 0) (17.89 14.85 0) 4)
  '((17.89 14.85 0) (17.79 14.66 0) 4)
  '((17.79 14.66 0) (17.71 14.47 0) 4)
  '((17.71 14.47 0) (17.64 14.27 0) 4)
  '((17.64 14.27 0) (17.58 14.07 0) 4)
  '((17.58 14.07 0) (17.54 13.87 0) 4)
  '((17.54 13.87 0) (17.5 13.67 0) 4)
  '((17.5 13.67 0) (17.48 13.46 0) 4)
  '((17.48 13.46 0) (17.48 13.25 0) 4)
  '((17.48 13.25 0) (17.48 13.04 0) 4)
  '((17.48 13.04 0) (17.5 12.84 0) 4)
  '((17.5 12.84 0) (17.54 12.63 0) 4)
  '((17.54 12.63 0) (17.58 12.43 0) 4)
  '((17.58 12.43 0) (17.64 12.23 0) 4)
  '((17.64 12.23 0) (17.71 12.03 0) 4)
  '((17.71 12.03 0) (17.79 11.84 0) 4)
  '((17.79 11.84 0) (17.89 11.65 0) 4)
  '((17.89 11.65 0) (17.99 11.48 0) 4)
  '((17.99 11.48 0) (18.11 11.3 0) 4)
  '((18.11 11.3 0) (18.24 11.14 0) 4)
  '((18.24 11.14 0) (18.37 10.98 0) 4)
  '((18.37 10.98 0) (18.52 10.84 0) 4)
  '((18.52 10.84 0) (18.68 10.7 0) 4)
  '((18.68 10.7 0) (18.84 10.57 0) 4)
  '((18.84 10.57 0) (19.01 10.45 0) 4)
  '((19.01 10.45 0) (19.19 10.35 0) 4)
  '((19.19 10.35 0) (19.38 10.25 0) 4)
  '((19.38 10.25 0) (19.57 10.17 0) 4)
  '((19.57 10.17 0) (19.77 10.1 0) 4)
  '((19.77 10.1 0) (19.97 10.04 0) 4)
  '((19.97 10.04 0) (20.17 10 0) 4)
  '((20.17 10 0) (20.37 9.96 0) 4)
  '((20.37 9.96 0) (20.58 9.94 0) 4)
  '((20.58 9.94 0) (20.79 9.94 0) 4)
  '((20.79 9.94 0) (21 9.94 0) 4)
  '((21 9.94 0) (21.2 9.96 0) 4)
  '((21.2 9.96 0) (21.41 10 0) 4)
  '((21.41 10 0) (21.61 10.04 0) 4)
  '((21.61 10.04 0) (21.81 10.1 0) 4)
  '((21.81 10.1 0) (22.01 10.17 0) 4)
  '((22.01 10.17 0) (22.2 10.25 0) 4)
  '((22.2 10.25 0) (22.38 10.35 0) 4)
  '((22.38 10.35 0) (22.56 10.45 0) 4)
  '((22.56 10.45 0) (22.74 10.57 0) 4)
  '((22.74 10.57 0) (22.9 10.7 0) 4)
  '((22.9 10.7 0) (23.06 10.84 0) 4)
  '((23.06 10.84 0) (23.2 10.98 0) 4)
  '((23.2 10.98 0) (23.34 11.14 0) 4)
  '((23.34 11.14 0) (23.47 11.3 0) 4)
  '((23.47 11.3 0) (23.58 11.48 0) 4)
  '((23.58 11.48 0) (23.69 11.65 0) 4)
  '((23.69 11.65 0) (23.78 11.84 0) 4)
  '((23.78 11.84 0) (23.87 12.03 0) 4)
  '((23.87 12.03 0) (23.94 12.23 0) 4)
  '((23.94 12.23 0) (24 12.43 0) 4)
  '((24 12.43 0) (24.04 12.63 0) 4)
  '((24.04 12.63 0) (24.07 12.84 0) 4)
  '((24.07 12.84 0) (24.09 13.04 0) 4)
  '((24.09 13.04 0) (24.1 13.25 0) 4)
  '((24.1 13.25 0) (24.1 13.25 0) 4)
  '((20.16 15.38 0) (20.79 16 0) 2)
  '((20.18 15.06 0) (21.06 15.94 0) 2)
  '((20.19 14.73 0) (21.25 15.79 0) 2)
  '((20.2 14.41 0) (21.38 15.58 0) 2)
  '((20.22 14.09 0) (21.41 15.28 0) 2)
  '((20.23 13.76 0) (21.39 14.93 0) 2)
  '((20.24 13.44 0) (21.38 14.58 0) 2)
  '((20.26 13.12 0) (21.37 14.23 0) 2)
  '((20.27 12.79 0) (21.35 13.87 0) 2)
  '((20.28 12.47 0) (21.34 13.52 0) 2)
  '((20.33 12.18 0) (21.32 13.17 0) 2)
  '((20.48 11.99 0) (21.31 12.82 0) 2)
  '((20.71 11.88 0) (21.29 12.47 0) 2)
  '((20.31 11.15 0) (20.64 11.48 0) 2)
  '((20.32 10.82 0) (20.97 11.47 0) 2)
  '((20.46 10.62 0) (21.17 11.33 0) 2)
  '((20.68 10.51 0) (21.28 11.11 0) 2)))
  (setq num 0)
  (while (setq sub (nth num grlist))
         (setq ten (car sub))
         (setq elv (cadr sub))
         (setq colo (caddr sub))
         (setq ten (list (+ (* xratio (car ten)) minx)
                         (+ (* yratio (cadr ten)) miny)))
         (setq elv (list (+ (* xratio (car elv)) minx)
                         (+ (* yratio (cadr elv)) miny)))
         (grdraw ten elv colo)
         (setq num (1+ num)))
 (princ))
 ; Ŀ
 ;   Warn end.                                                             
 ; 

 ; Ŀ
 ;   Vvbc - Vvb with horizontal rejustify.                                 
 ;   This doesn't decide - as vvb does - whether to use the insertion      
 ;   point or the ten point since we are moving the entities on both axes. 
 ; 
 (DEFUN C:VVBC (/ *error* ss hiet difa ctr orlst entt pap angg angga pa incdef
                                                incr istr incrp num txa inspt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (command "undo" "end")
   (write-line shk)
  (princ))
 ; Ŀ
 ;   Get an ss of text and attribute entities.                             
 ; 
  (prompt "Pick text strings:")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
 ; Ŀ
 ;   Find the tallest entity in the ss, warn if there are different sizes. 
 ; 
  (setq hiet (shizl ss))
  (setq difa (cadr hiet))
  (setq hiet (car hiet))
  (if difa
      (progn
           (prompt "\n* That set contained text of varying sizes. *")
           (setq ctr (getvar "viewctr"))
           (warn ctr)))
 ; Ŀ
 ;   Make a list of enames, ordered by decreasing position.                
 ; 
  (setq orlst (vtol ss "y" t))
 ; Ŀ
 ;   Get an insertion point.  Offer the highest insertion as the default.  
 ; 
  (setq entt (entget (car orlst)))
  (setq pap (spit entt))
  (setq angg (cdr (assoc 50 entt)))
  (setq angga (+ angg (* pi 1.5)))
  (setq pa (getpoint pap "\nStartpoint or <Return>: "))
  (if (null pa) (setq pa pap))
 ; Ŀ
 ;   Ask for a line spacing.                                               
 ; 
  (setq incdef (* 1.65 hiet))
  (if (/= (type incr) 'REAL) (setq incr incdef))
  (if (= incr incdef)
      (setq istr (strcat "\nLine spacing <" (rtos incr 2 2) ">: "))
      (setq istr (strcat "\nLine spacing <" (rtos incr 2 2)
                         ">/Default (" (rtos incdef 2 2) "): ")))
  (initget 128 "Default")
  (setq incrp (getdist pa istr))
  (cond ((and incrp (= (type incrp) 'REAL))
         (setq incr incrp))
        ((and incrp (= incrp "Default"))
         (setq incr incdef)))
 ; Ŀ
 ;   Reshuffle everything in the order implicit in Orlst.                  
 ; 
  (setq num 0)
  (while (setq txa (nth num orlst))
         (setq num (1+ num))
         (setq inspt (spit (entget txa)))
         (command "move" txa "" inspt pa)
         (setq pa (polar pa angga incr)))
 ; Ŀ
 ;   Select the ss again so that it will be the Previous set.              
 ; 
  (command "select" ss "")
 ; Ŀ
 ;   Sum up and go home.                                                   
 ; 
  (prompt (strcat "\n" (itoa num) " line"
                  (if (= num 1) "" "s") " restratified."))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Vvbc end.                                                             
 ; 

 ; Ŀ
 ;   Vvb.                                                                  
 ; 
 (DEFUN C:VVB (/ *error* ss hiet yjusts xjusts difa ctr useins orlst pap pa
                                  incdef istr incrp num txa inspt yold ynew)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (command "undo" "end")
   (write-line shk)
  (princ))
 ; Ŀ
 ;   Get an ss of text and attribute entities.                             
 ; 
  (prompt "Pick text strings:")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
 ; Ŀ
 ;   Find the tallest entity in the ss, warn if there are different sizes. 
 ;   Also see if there are different justifications.                       
 ; 
  (setq hiet (shizl ss))
  (setq yjusts (caddr hiet))   ; y justifications list
  (setq xjusts (cadddr hiet))  ; x justifications list
  (setq difa (cadr hiet))      ; t if different heights
  (setq hiet (car hiet))       ; greatest height
  (if difa
      (progn
           (prompt "\n* That set contained text of varying sizes. *")
           (setq ctr (getvar "viewctr"))
           (warn ctr)))
 ; Ŀ
 ;   Make a list of enames, ordered by decreasing Y position.              
 ;   If all justifications are the same then use the insertion point       
 ;   as the base point, otherwise use the ten point.                       
 ;   This should avoid having columns of mixed C and M justified text      
 ;   reshuffling oddly.                                                    
 ; 
  (if (and (= (length xjusts) 1)
           (= (length yjusts) 1))
      (setq useins t))
  (setq orlst (vtol ss "Y" useins))
 ; Ŀ
 ;   Get an insertion point.  Offer the highest insertion or ten point,    
 ;   depending on Useins, as the default.                                  
 ; 
  (if useins
      (setq pap (spit (entget (car orlst))))
      (setq pap (cdr (assoc 10 (entget (car orlst))))))
  (setq pa (getpoint pap "\nStartpoint or <Return>: "))
  (if (null pa) (setq pa pap))
 ; Ŀ
 ;   Ask for a line spacing.                                               
 ; 
  (setq incdef (* 1.65 hiet))
  (if (/= (type incr) 'REAL) (setq incr incdef))
  (if (= incr incdef)
      (setq istr (strcat "\nLine spacing <" (rtos incr 2 2) ">: "))
      (setq istr (strcat "\nLine spacing <" (rtos incr 2 2)
                         ">/Default (" (rtos incdef 2 2) "): ")))
  (initget 128 "Default")
  (setq incrp (getdist pa istr))
  (cond ((and incrp (= (type incrp) 'REAL))
         (setq incr incrp))
        ((and incrp (= incrp "Default"))
         (setq incr incdef)))
 ; Ŀ
 ;   Reshuffle everything in the order implicit in Orlst.                  
 ; 
  (setq num 0)
  (while (setq txa (nth num orlst))
         (setq num (1+ num))
         (if useins
             (setq inspt (spit (entget txa)))
             (setq inspt (cdr (assoc 10 (entget txa)))))
         (setq yold (cadr inspt))
         (setq ynew (cadr pa))
         (command "move" txa "" (list 0 yold) (list 0 ynew))
         (setq pa (list (car pa) (- (cadr pa) incr))))
 ; Ŀ
 ;   Select the ss again so that it will be the Previous set.              
 ; 
  (command "select" ss "")
 ; Ŀ
 ;   Sum up and go home.                                                   
 ; 
  (prompt (strcat "\n" (itoa num) " line"
                  (if (= num 1) "" "s") " restratified."))
  (command "undo" "end")
 (princ))